// SetOSDBuffer.cpp : implementation file
//

#include "stdafx.h"
#include "MyOSDProperty.h"
#include "SetOSDBuffer.h"
#include "afxdialogex.h"


// CSetOSDBuffer dialog

IMPLEMENT_DYNAMIC(CSetOSDBuffer, CDialogEx)

CSetOSDBuffer::CSetOSDBuffer(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSetOSDBuffer::IDD, pParent)
	, m_nBufferTransparent(255)
	, m_nSrcBufferWidth(1920)
	, m_nSrcBufferHeight(1080)
{
	m_clrKeyColor = RGB( 0, 0, 0 );

	m_pOSDAlphaBlender = NULL;

	m_pFrameBuffer = NULL;

	m_nOSDLayer = 2;

	m_nKeyColorThreshold = 25;
	
	m_nXOffset = 0;

	m_nYOffset = 0;

	m_nWidth = 1920;

	m_nHeight = 1080;

	m_nColorSpace = 0;
}

CSetOSDBuffer::~CSetOSDBuffer()
{
}

void CSetOSDBuffer::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_TEXT_X_OFFSET, m_nXOffset);
	DDV_MinMaxInt(pDX, m_nXOffset, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_Y_OFFSET, m_nYOffset);
	DDV_MinMaxInt(pDX, m_nYOffset, 0, 1080);
	DDX_Text(pDX, IDC_EDIT_TEXT_WIDTH, m_nWidth);
	DDV_MinMaxInt(pDX, m_nWidth, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_TEXT_HEIGHT, m_nHeight);
	DDV_MinMaxInt(pDX, m_nHeight, 0, 1080);
	DDX_Control(pDX, IDC_COMBO_BUFFER_OSD_LAYER, m_comboOSDBufferLayer);
	DDX_Control(pDX, IDC_COMBO_BUFFER_COLOR_SPACE, m_comboBufferColorSpace);
	DDX_Text(pDX, IDC_EDIT_BUFFER_TRANSPARENT, m_nBufferTransparent);
	DDV_MinMaxInt(pDX, m_nBufferTransparent, 0, 255);
	DDX_Text(pDX, IDC_EDIT_SRC_BUFFER_WIDTH, m_nSrcBufferWidth);
	DDV_MinMaxInt(pDX, m_nSrcBufferWidth, 0, 1920);
	DDX_Text(pDX, IDC_EDIT_SRC_BUFFER_HEIGHT, m_nSrcBufferHeight);
	DDV_MinMaxInt(pDX, m_nSrcBufferHeight, 0, 1080);
	DDX_Control(pDX, IDC_EDIT_BUFFER_FILE_PATH, m_editBufferPath);
	DDX_Control(pDX, IDC_SC_KEY_COLOR, m_scKeyColor);
	DDX_Control(pDX, IDC_COMBO_BUFFER_OSD_KEY_COLOR_THRESHOLD, m_comboKeyColorThresHold);
}


BEGIN_MESSAGE_MAP(CSetOSDBuffer, CDialogEx)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDOK, &CSetOSDBuffer::OnBnClickedOk)
	ON_BN_CLICKED(IDCANCEL, &CSetOSDBuffer::OnBnClickedCancel)
	ON_BN_CLICKED(ID_BROWSER_BUFFER_PATH, &CSetOSDBuffer::OnBnClickedBrowserBufferPath)	
	ON_BN_CLICKED(ID_SET_ALPHA_BLENDING, &CSetOSDBuffer::OnBnClickedSetAlphaBlending)	
	ON_BN_CLICKED(ID_MOVE_TEXT_OBJECT, &CSetOSDBuffer::OnBnClickedMoveTextObject)
	ON_STN_CLICKED(IDC_SC_KEY_COLOR, &CSetOSDBuffer::OnClickedScKeyColor)
	ON_CBN_SELCHANGE(IDC_COMBO_BUFFER_OSD_KEY_COLOR_THRESHOLD, &CSetOSDBuffer::OnSelchangeComboKeyColorThresHold)
END_MESSAGE_MAP()


// CSetOSDBuffer message handlers

BOOL CSetOSDBuffer::OnInitDialog()
{
	CDialogEx::OnInitDialog();	

	// TODO: Add extra initialization here

	m_comboOSDBufferLayer.ResetContent();	

	CString str;

	int i = 0;

	for ( i = 0 ; i < 16 ; i++ )
	{
		str.Format(_T("%d"),  i );

		m_comboOSDBufferLayer.AddString( str );
	}

	for ( i = 0 ; i < 128 ; i++ )
	{
		str.Format(_T("%d"),  i );

		m_comboKeyColorThresHold.AddString( str );
	}

	m_comboOSDBufferLayer.SetCurSel( 2 );

	m_comboKeyColorThresHold.SetCurSel( 26 );

	m_comboBufferColorSpace.ResetContent();

	m_comboBufferColorSpace.AddString( "YUY2" );

	m_comboBufferColorSpace.AddString( "YV12" );

	m_comboBufferColorSpace.AddString( "RGB24" );

	m_comboBufferColorSpace.AddString( "BGR24" );

	m_comboBufferColorSpace.AddString( "ARGB32" );
		
	m_comboBufferColorSpace.AddString( "ABGR32" );

	m_comboBufferColorSpace.SetCurSel( 0 );

	m_pFrameBuffer = new BYTE[ 1920 * 1080 * 4 ];

	ZeroMemory( m_pFrameBuffer, 1920 * 1080 * 4 );

	m_scKeyColor.SetBkColor( m_clrKeyColor );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetOSDBuffer::OnDestroy()
{
	delete [] m_pFrameBuffer;

	m_pFrameBuffer = NULL;

	CDialogEx::OnDestroy();
}

void CSetOSDBuffer::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	int nIndex = m_comboOSDBufferLayer.GetCurSel();	

	m_nOSDLayer = nIndex;

	nIndex = m_comboBufferColorSpace.GetCurSel();

	if ( nIndex == 0 ) m_nColorSpace = COLORSPACE_TYEP_YUY2;

	if ( nIndex == 1 ) m_nColorSpace = COLORSPACE_TYEP_YV12;

	if ( nIndex == 2 ) m_nColorSpace = COLORSPACE_TYEP_RGB24;

	if ( nIndex == 3 ) m_nColorSpace = COLORSPACE_TYEP_BGR24;

	if ( nIndex == 4 ) m_nColorSpace = COLORSPACE_TYEP_ARGB32;

	if ( nIndex == 5 ) m_nColorSpace = COLORSPACE_TYEP_ABGR32;

	BOOL bSetOSDBuffer = FALSE;

	if ( m_pOSDAlphaBlender != NULL && m_pFrameBuffer != NULL )
	{
		Gdiplus::ARGB aKeyColor = RGB2ARGB( m_clrKeyColor );

		bSetOSDBuffer = AMESDK_OSD_SET_BUFFER( m_pOSDAlphaBlender, 
				
																						 m_nOSDLayer,

																						 m_nXOffset,

																						 m_nYOffset,

																						 m_nWidth,

																						 m_nHeight, 

																						 m_nColorSpace,

																						 m_pFrameBuffer,

																						 m_nSrcBufferWidth,

																						 m_nSrcBufferHeight,

																						 0,

																						 m_nBufferTransparent,

																						aKeyColor, // 0xFFFFFFFF (OFF), 0x00FF0000 (BLUE), 0x0000FF00 (GREEN), 0x000000FF (RED)

																						 m_nKeyColorThreshold,  

																						 0,

																						 NULL );
	}

	//CDialogEx::OnOK();
}


void CSetOSDBuffer::OnBnClickedCancel()
{
	// TODO: Add your control notification handler code here

	CDialogEx::OnCancel();
}


void CSetOSDBuffer::OnBnClickedBrowserBufferPath()
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	int nIndex = m_comboBufferColorSpace.GetCurSel();

	ULONG nFrameSize = 0;

	if ( nIndex == 0 )
	{
		m_nColorSpace = COLORSPACE_TYEP_YUY2;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 2;
	}

	if ( nIndex == 1 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_YV12;

		nFrameSize = ( m_nSrcBufferWidth * m_nSrcBufferHeight * 3 ) / 4;
	}

	if ( nIndex == 2 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_RGB24;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 3;
	}

	if ( nIndex == 3 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_BGR24;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 3;
	}

	if ( nIndex == 4 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_ARGB32;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 4;
	}

	if ( nIndex == 5 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_ABGR32;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 4;
	}

	//
	//
	CString			csOpenFileName;

	TCHAR			szCpation[] = _T("Select a raw file");

	TCHAR	strFileBuf[0x2000];

	::memset(strFileBuf, 0, sizeof(TCHAR) * 0x19F0);

	CFileDialog	fileDialog(	TRUE, 
										   _T("yuy2"), 
										   NULL, 
										   NULL, 
										   _T("Binary Files (*.yuy2;*.yv12;*.rgb24,*.bgr24;*.argb32;*.abgr32)|*.yuy2;*.yv12;*.rgb24,*.bgr24;*.argb32;*.abgr32|All Files (*.*)|*.*||")
										   );

	fileDialog.m_ofn.lpstrTitle = szCpation;

	fileDialog.m_ofn.lpstrInitialDir = m_strBrowseFilePath;	

	fileDialog.m_ofn.lpstrFile = strFileBuf;

	if (IDOK == fileDialog.DoModal())	
	{
		CString strCurPath = fileDialog.GetPathName();

		if (strCurPath.Find('.') != -1)
			strCurPath = strCurPath.Left(strCurPath.ReverseFind('\\') + 1);

		m_strBrowseFilePath = strCurPath;

		m_strLoadBuffer = fileDialog.GetPathName();

		m_editBufferPath.SetWindowText( m_strLoadBuffer );

		CStdioFile	*pFileBin = NULL;

		pFileBin = new CStdioFile( m_strLoadBuffer,  CFile::modeRead | CFile::typeBinary);

		ZeroMemory( m_pFrameBuffer, 1920 * 1080 * 4 );

		pFileBin->Read( m_pFrameBuffer, nFrameSize );

		pFileBin->Close();

		delete pFileBin;
	}
}


void CSetOSDBuffer::OnBnClickedSetAlphaBlending()
{
	// TODO: Add your control notification handler code here

	UpdateData( TRUE );

	int nIndex = m_comboBufferColorSpace.GetCurSel();

	ULONG nFrameSize = 0;

	if ( nIndex == 0 )
	{
		m_nColorSpace = COLORSPACE_TYEP_YUY2;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 2;
	}

	if ( nIndex == 1 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_YV12;

		nFrameSize = ( m_nSrcBufferWidth * m_nSrcBufferHeight * 3 ) / 4;
	}

	if ( nIndex == 2 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_RGB24;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 3;
	}

	if ( nIndex == 3 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_BGR24;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 3;
	}

	if ( nIndex == 4 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_ARGB32;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 4;
	}

	if ( nIndex == 5 ) 
	{
		m_nColorSpace = COLORSPACE_TYEP_ABGR32;

		nFrameSize = m_nSrcBufferWidth * m_nSrcBufferHeight * 4;
	}

	BOOL bSetAlphaBlending = FALSE;

	if ( m_pOSDAlphaBlender != NULL && m_pFrameBuffer != NULL )
	{
		bSetAlphaBlending = AMESDK_OSD_SET_ALPHA_BLENDING(	m_pOSDAlphaBlender, 
			
																													m_nColorSpace, 
																													
																													m_nSrcBufferWidth, 
																													
																													m_nSrcBufferHeight, 
																													
																													m_pFrameBuffer, 
																													
																													nFrameSize );
	}
	
}

void CSetOSDBuffer::OnSelchangeComboKeyColorThresHold()
{
	// TODO: Add your control notification handler code here

	int nIndex = m_comboKeyColorThresHold.GetCurSel();

	CString str;	

	m_comboKeyColorThresHold.GetLBText( nIndex, str );

	m_nKeyColorThreshold = atoi( str );
}

void CSetOSDBuffer::OnBnClickedMoveTextObject()
{
	// TODO: Add your control notification handler code here

	if ( m_pOSDAlphaBlender != NULL )
	{
		AMESDK_OSD_MOVE_OBJ( m_pOSDAlphaBlender, m_nOSDLayer, 300, 300 );
	}
}

void CSetOSDBuffer::OnClickedScKeyColor()
{
	CColorDialog clrDlg( m_clrKeyColor );	

	if ( clrDlg.DoModal() == IDOK )
	{
		m_clrKeyColor = clrDlg.GetColor();

		m_scKeyColor.SetBkColor( m_clrKeyColor );		
	}
}
